import { Router } from 'express';
import { adminController } from './controller';
import { authenticateUser, requireAdmin } from '@/middlewares/auth';

const router = Router();

// Attach admin to req for downstream use (simulate admin extraction)
async function attachAdmin(req: any, res: any, next: any) {
  req.admin = req.user; // Assume admin is authenticated user for now
  next();
}

// Admin user management
router.get('/users', authenticateUser, requireAdmin, attachAdmin, adminController.listAdmins);
router.post('/users', authenticateUser, requireAdmin, attachAdmin, adminController.createAdmin);
router.patch('/users/:id/permissions', authenticateUser, requireAdmin, attachAdmin, adminController.updateAdminPermissions);

// Admin settings
router.get('/settings', authenticateUser, requireAdmin, attachAdmin, adminController.getSettings);
router.patch('/settings', authenticateUser, requireAdmin, attachAdmin, adminController.updateSettings);

// Admin logs
router.get('/logs', authenticateUser, requireAdmin, attachAdmin, adminController.getLogs);

// Feature flags
router.patch('/feature-flags', authenticateUser, requireAdmin, attachAdmin, adminController.updateFeatureFlags);

// KYC/pricing agent approval
router.patch('/kyc/:id', authenticateUser, requireAdmin, attachAdmin, adminController.approveKYCOrPricing);

// Impersonation
router.post('/impersonate', authenticateUser, requireAdmin, attachAdmin, adminController.impersonate);

// Audit trail
router.get('/audit-trail', authenticateUser, requireAdmin, attachAdmin, adminController.getAuditTrail);

// Support tickets
router.get('/support-tickets', authenticateUser, requireAdmin, attachAdmin, adminController.getSupportTickets);
router.patch('/support-tickets/:id', authenticateUser, requireAdmin, attachAdmin, adminController.updateSupportTicket);

// Admin notifications
router.get('/notifications', authenticateUser, requireAdmin, attachAdmin, adminController.getAdminNotifications);

export default router; 